*** COS 2021 10, last update 2022 11  
           
           
           
program define dq_acc_uo1, rclass  
           
syntax varlist(numeric) [if] [in], [structure(string)  outcheck(int 1) outsens(int 1) outintegrate(int 1) nomod(int 0) metriclevels(int 25) breakreport (int 0) histkat(int 11) gdth(string) forcecalc(int 0) decimals(int 2)  indent(int 0)]  
marksample touse, novarlist  
           
	 					    
           
local indent=`indent'+5  
local adoname "dq_acc_uo1"  
local text_i "di as text _n "  					  
           
           
local sdfactor=		3*`outsens'					  
local Grubbslevel=	97.5+2.49-2.49/`outsens'	  
local adjTukey=		2*`outsens'					  
local adjBox=		1.5*`outsens'				  
           
local tablecaption1 "$tableextremecaption_1"  
local tablecaption2 "" 					  
local tablecaption3 "" 					  
	          
if `outsens'<0.5  `text_i' "Unuseful outsens selection `outsens' changes to the allowable minimum 0.5"  
local outsens=max(0.5,`outsens')	  
           
           
           
foreach var of varlist `varlist' {  
	          
	local pointer "$`var'"         							  
	local vt_number="vtnum_`pointer'"						  
	local spt="`structure'_`pointer'"						  
	          
           
	          
	local performcheck=0  
	qui capture confirm scalar scalelevel_$`pointer'  
	if _rc==0{  
	    if strpos("`=scalelevel_$`pointer''","ratio")>0 | strpos("`=scalelevel_$`pointer''","interval")>0 {  
			local performcheck=1  
		}        
	}         
	          
	if `performcheck'==1 & $`vt_number'<5 {  
	          
		qui count if `touse' & `var'<.  
		local Nall=r(N)											  
           
		tempvar outlier_abp  
		tempvar outlier_gru  
		tempvar outlier_tu  
		tempvar outlier_atu  
		tempvar outlier_sd  
		tempvar outlier_count  
	          
		dq_des_gh1 `var' `subgroup', ststrata("`structure'") gd(`gdth') histkat(`histkat') forcecalc(`forcecalc') thumbs(1)  indent(`indent')	  
           
		         
           
		if `outcheck'<4 | `outcheck'==10 {  
	          
			if `=vp_p50_`spt''>`=vp_min_`spt'' {	  
				qui robstat `var', s(MC)  
				mat def mctab=r(table)  
				if mctab[1,1] >=0 {  
					scalar uo1_abpl_`spt'	=	`=vp_p25_`spt''-`adjBox'*exp(-3.5*mctab[1,1])	* `=vp_iqr_`spt''  
					scalar uo1_abpu_`spt'	=	`=vp_p75_`spt''+`adjBox'*exp(4*mctab[1,1])		* `=vp_iqr_`spt''  
				}      
				if mctab[1,1] <0 {  
					scalar uo1_abpl_`spt'	=	`=vp_p25_`spt''-`adjBox'*exp(-4*mctab[1,1])		* `=vp_iqr_`spt''  
					scalar uo1_abpu_`spt'	=	`=vp_p75_`spt''+`adjBox'*exp(3.5*mctab[1,1])	* `=vp_iqr_`spt''  
				}				  
				qui gen 	`outlier_abp'=0  
				qui replace `outlier_abp'=1 if `touse' & `var' < `=uo1_abpl_`spt'' 			  
				qui replace `outlier_abp'=2 if `touse' & `var' > `=uo1_abpu_`spt'' & `var'<.	  
				qui count if `touse' & `outlier_abp'==1  
				scalar uo1_abpl_NU_`spt'	=	r(N)											  
				qui count if `touse' & `outlier_abp'==2  
				scalar uo1_abpu_NU_`spt'	=	r(N)											  
				if strpos("`tablecaption1'","Medcouple")==0 local tablecaption1 "`tablecaption1' Medcouple (mc) Brown (2005) P25/75 -/+`adjBox'*exp(-3.5/-4/4/-3.5*mc)*IQR; "						  
			}       
			if `=vp_p50_`spt''==`=vp_min_`spt'' {  
				`text_i' "Adjusted boxplot for outlier assessment of `var' NOT computable"  
				qui gen 	`outlier_abp'=. 		  
				if strpos("`tablecaption2'","$tableextremecaption_2")==0 local tablecaption2 "`tablecaption2' $tableextremecaption_2"					  
			}	      
		}	       
		         
		if `outcheck'==3 | `outcheck'==19 {  
			if `=vp_iqr_`spt''>0 {  
				scalar uo1_tukl_`spt'	=	`=vp_p25_`spt''-1.5*`=vp_iqr_`spt''  
				scalar uo1_tuku_`spt'	=	`=vp_p75_`spt''+1.5*`=vp_iqr_`spt''  
				qui gen 	`outlier_tu'=0  
				qui replace	`outlier_tu'=1 if `touse' & `var' < `=uo1_tukl_`spt'' 				  
				qui replace `outlier_tu'=2 if `touse' & `var' > `=uo1_tuku_`spt'' & `var'<. 	  
				qui count if `touse' & `outlier_tu'==1  
				scalar uo1_tukl_NU_`spt'	=	r(N)									  
				qui count if `touse' & `outlier_tu'==2  
				scalar uo1_tuku_NU_`spt'	=	r(N)									  
				if strpos("`tablecaption1'","p25-1.5*IQR")==0 local tablecaption1 "`tablecaption1' : Tukey: p25-1.5*IQR / p75+1.5*IQR; "  
			}       
			if `=vp_iqr_`spt''==0 {  
				`text_i' "Tukey based check for outlier assessment of `var' NOT useful"  
				qui gen 	`outlier_tu'=. 		  
				if strpos("`tablecaption2'","$tableextremecaption_2")==0 local tablecaption2 "`tablecaption2' $tableextremecaption_2; "  
			}       
		}        
		         
		if `outcheck'==2 | `outcheck'==3 | `outcheck'==11 {  
			scalar uo1_sdl_`spt'	=	`=vp_mean_`spt''-`sdfactor'*`=vp_sd_`spt''	  
			scalar uo1_sdu_`spt'	=	`=vp_mean_`spt''+`sdfactor'*`=vp_sd_`spt''  
			qui gen 	`outlier_sd'=0  
			qui replace `outlier_sd'=1 if `touse' & `var' < `=uo1_sdl_`spt'' 					  
			qui replace `outlier_sd'=2 if `touse' & `var' > `=uo1_sdu_`spt'' & `var'<. 			  
			qui count if `touse' & `outlier_sd'==1  
			scalar uo1_sdl_NU_`spt'	=	r(N)									  
			qui count if `touse' & `outlier_sd'==2  
			scalar uo1_sdu_NU_`spt'	=	r(N)									  
			if strpos("`tablecaption1'","SD:")==0 local tablecaption1 "`tablecaption1' SD: $Mean_1 +/-`sdfactor'*SD; "			  
		}        
		         
		if `outcheck'<4 | `outcheck'==12 {  
			local leveladapt=97.5+2.49-5/`outsens'										  
			qui grubbs `var', gen(`outlier_gru') iter(16000) level(`Grubbslevel')  
			qui replace `outlier_gru'=2 if `touse' & `outlier_gru'==1 & `var'> `=vp_mean_`spt''		  
			qui count if `touse' & `outlier_gru'==1  
			scalar uo1_grl_NU_`spt'	=	r(N)									  
			qui count if `touse' & `outlier_gru'==2  
			scalar uo1_gru_NU_`spt'	=	r(N)									  
			if strpos("`tablecaption1'","Grubbs")==0 local tablecaption1 "`tablecaption1' Grubbs Test: (CI `Grubbslevel'); "			  
		}        
		         
		if `outcheck'==2 | `outcheck'==3 |  `outcheck'==13 {  
			if `=vp_p95_`spt''-`=vp_p5_`spt''>0 {  
				scalar uo1_atukl_`spt'	=	`=vp_p10_`spt''-`adjTukey'*(`=vp_p25_`spt''-`=vp_p5_`spt'')  
				scalar uo1_atuku_`spt'	=	`=vp_p90_`spt''+`adjTukey'*(`=vp_p95_`spt''-`=vp_p75_`spt'')  
				qui gen 	`outlier_atu'=0  
				qui replace `outlier_atu'=1 if `touse' & `var' < `=uo1_atukl_`spt'' 	  
				qui replace `outlier_atu'=2 if `touse' & `var' > `=uo1_atuku_`spt'' & `var'<. 	  
				qui count if `touse' & `outlier_atu'==1  
				scalar uo1_atukl_NU_`spt'	=	r(N)									  
				qui count if `touse' & `outlier_atu'==2  
				scalar uo1_atuku_NU_`spt'	=	r(N)									  
				if strpos("`tablecaption1'","adjusted Tukey")==0 local tablecaption1 "`tablecaption1' adjusted Tukey: p10-`adjTukey'*(p25-p5); p90+`adjTukey'*(p95-p75); "						  
			}       
			if `=vp_p95_`spt''-`=vp_p5_`spt''==0 {  
				qui gen 	`outlier_atu'=. 			  
				if strpos("`tablecaption2'","$tableextremecaption_2")==0 local tablecaption2 "`tablecaption2' $tableextremecaption_2; "					  
			}       
		}	       
		         
           
				       
		if `outintegrate'==0 {  
		}        
		if `outintegrate'==1  {  
			local uvcheckvars "`outlier_gru' `outlier_abp'"  
			if strpos("`tablecaption3'","$tableextremecaption_3")==0 local tablecaption3  "$tableextremecaption_3"  
		}        
		if `outintegrate'==2  {  
			local uvcheckvars "`outlier_atu' `outlier_sd' `outlier_gru' `outlier_abp' `outlier_tuk'"  
			if strpos("`tablecaption3'","$tableextremecaption_4")==0 local tablecaption3  "$tableextremecaption_4"  
		}        
		if `outintegrate'==3  {  
			local uvcheckvars "`outlier_atu' `outlier_sd' `outlier_gru' `outlier_abp'"  
			if strpos("`tablecaption3'","$tableextremecaption_4")==0 local tablecaption3  "$tableextremecaption_4"  
		}        
		if `outintegrate'==10 local uvcheckvars "`outlier_abp'"  
		if `outintegrate'==11 local uvcheckvars "`outlier_sd'"  
		if `outintegrate'==12 local uvcheckvars "`outlier_gru'"  
		if `outintegrate'==13 local uvcheckvars "`outlier_atu'"  
		if `outintegrate'==19 local uvcheckvars "`outlier_tu'"  
		         
		         
		if "`uvcheckvars'"~="" {  
			qui egen `outlier_count'=anycount(`uvcheckvars'), values(1 2)	  
			*di wordcount("`uvcheckvars'")  
			qui replace `outlier_count'=0 if `outlier_count' <wordcount("`uvcheckvars'")  
			qui replace `outlier_count'=1 if `outlier_count'>=wordcount("`uvcheckvars'")		  
			if `outintegrate'==1 {  
				qui replace `outlier_count'=1 if `=vp_skew_`spt''>1 & `outlier_abp'==1  
				qui replace `outlier_count'=1 if `=vp_skew_`spt''<-1 & `outlier_abp'==2  
			}       
			        
			*tab `outlier_count'  
			qui count if `touse' & `outlier_count'==1  
			scalar uo1_dlc_NU_`spt' = r(N)  
			scalar uo1_dlc_PE_`spt' = `=uo1_dlc_NU_`spt''/`Nall'*100  
			        
		}        
		else qui gen `outlier_count' =.																  
	 	        
           
           
		if `nomod'<1 & "`uvcheckvars'"~="" {  
			qui replace `var'=. if `outlier_count'==1 										  
			* Add to change scalar,  First transfer to original variable because otherwise a modified variable scalar is created  
			local changescalar= strreverse(strreverse(subinstr("changeextreme_`spt'","_mpt","_pt",1)))  
			scalar `changescalar' = `=uo1_dlc_NU_`spt''  
			*sum `var' `var',det  
		} //end check all transformations to be transferred  
		         
		         
		capture drop `outlier_tu'  
		capture drop `outlier_atu'  
		capture drop `outlier_sd'  
		capture drop `outlier_gru'  
		capture drop `outlier_abp'  
		capture drop `outlier_count'  
 	         
	}	        
           
} 	        
           
dq_hlp_std ,  numstring("`sdfactor'") decimals(`decimals')  indent(`indent')  
local sdfactor="`r(numstring)'"	  
dq_hlp_std ,  numstring("`Grubbslevel'") decimals(`decimals')  indent(`indent')  
local Grubbslevel="`r(numstring)'"  
dq_hlp_std ,  numstring("`sdfactor'") decimals(`decimals')  indent(`indent')  
local adjTukey="`r(numstring)'"	  
           
global uo1_dlc_PE 			"DQI Outliers"	  
           
global uo1_tukl 			"Tukey LB"  
global uo1_tuku 			"Tukey UB"  
global uo1_tukl_NU 			"Tukey"  
global uo1_tuku_NU 			"Tukey"  
	          
global uo1_sdl 				"SD based LB"  
global uo1_sdu 				"SD based UB"	  
global uo1_sdl_NU 			"SD based"  
global uo1_sdu_NU 			"SD based"	  
           
global uo1_grl 				"Grubbs"  
global uo1_gru 				"Grubbs"	  
global uo1_grl_NU 			"Grubbs"  
global uo1_gru_NU 			"Grubbs"	  
	 	        
global uo1_atukl 			"adj.Tukey LB"  
global uo1_atuku 			"adj.Tukey UB"	  
global uo1_atukl_NU 		"adj.Tukey"  
global uo1_atuku_NU 		"adj.Tukey"	  
	          
global uo1_abpl 			"Medc. LB"  
global uo1_abpu 			"Medc. UB"	  
global uo1_abpl_NU 			"Medc."  
global uo1_abpu_NU 			"Med."	  
		         
global uo1_dlc 				"Outliers"	  
global uo1_dlc_PE 			"Outliers"		  
global uo1_dlc_NU 			"Outliers"  
           
global 	tableextremecaption1 "`tablecaption1' `tablecaption2' `tablecaption3'"	  
           
end        
           
